<?php

function isValidEmail( $email = null )
{
	return preg_match( "/^
	[\d\w\/+!=#|$?%{^&}*`'~-]
	[\d\w\/\.+!=#|$?%{^&}*`'~-]*@
	[A-Z0-9]
	[A-Z0-9.-]{0,61}
	[A-Z0-9]\.
	[A-Z]{2,6}$/ix", $email );
}

try {
	// Connect to the SQLite Database.
	$db = new PDO('mysql:host=localhost;dbname=comingsoon', 'user', 'password');
} catch(Exception $e) {
	die('connection_unsuccessful');
}

/* Check if table exists */
$db->exec('CREATE TABLE IF NOT EXISTS subscribers (email VARCHAR(255), time VARCHAR(255))');

/* Check if email has been posted */
if ( isset($_POST['email']) ) {

	/* Validate email */
	if ( isValidEmail($_POST['email']) ) {
		
		/* Check for duplication */
		$query = $db->prepare('SELECT COUNT(*) AS count FROM subscribers WHERE email = :email');  
		$query->execute(array(':email' => $_POST['email']));
		$result = $query->fetch();
				
		if ( $result['count'] == 0 ) { // E-mail is unique.
		
			$query = $db->prepare('INSERT INTO subscribers (email, time) VALUES (:email, :time)');  
			$query->execute(array('email' => $_POST['email'], 'time' => date('Y-m-d H:i:s')));
			
			echo 'successful';
			
		} else { // E-mail is already being used.
			echo 'already_subscribed';
		}
		
	} else {
		echo 'invalid_email';
	}
	
}
