<?php
/*
Template Name: Home
*/
?>
<?php get_header(); ?>	
 	
	<?php 
	$intro_text = of_get_option( 'intro_text' );
	$slider_disabled = intval( of_get_option( 'slider_disabled', '0' ) );
	$latest_articles_enabled = intval( of_get_option( 'latest_articles_enabled', '0' ) );
	$projects_per_row = intval( of_get_option( 'number_of_featured_projects_per_row', '3' ) ); //get the number of latest project to display on the home page
	$number_of_rows = intval( of_get_option( 'number_of_featured_project_rows', '3' ) );
	$image_width = 218;
	$image_height = 175;
	$quality = 90;
	$grid_class = 'grid_3';
	$items_count_class = 'four-items-per-row';
	$portfolio_page_id = intval( of_get_option( 'portfolio_link' ) );
	$portfolio_url = get_page_link( $portfolio_page_id );
	$has_posts_page = get_option('page_for_posts'); // Retrieves 0 if the page for posts isn't defined
	$blog_url = '';

	if($has_posts_page) {
		$blog_url = get_page_link(get_option('page_for_posts')); 
	}
			
	// Override the default settings if the number of projects per row is not four
	if ( $projects_per_row === 3 ) {
		$image_width = 300;
		$image_height = 210;
		$grid_class = 'grid_4';
		$items_count_class = 'three-items-per-row';
	}
	else if ( $projects_per_row === 2 ) {
		$image_width = 460;
		$image_height = 330;
		$grid_class = 'grid_6';
		$items_count_class = 'two-items-per-row';
	}		     
	?>
	
	<?php if( $intro_text ) { // display the introduction text if it's defined in the theme options panel ?>
		<!-- START #intro-section -->
	    <section id="intro-section">
	    	<h1 id="main-headline"><?php echo $intro_text; ?></h1>
	    </section>  
	    <!-- END #intro-section -->
    <?php } ?>
    
    <?php if( !( $slider_disabled ) ) { // If the slider is not disabled, embed it in the page ?>
    		
 		<?php get_template_part('slider'); ?>
 		
	<?php } ?>     
	
		<!-- START .latest-projects -->
		<section class="latest-projects group <?php echo $projects_class = ( $slider_disabled && !$intro_text ) ? 'no-slider-and-intro ' : 'with-slider-or-intro '; echo $items_count_class; ?>">
			
			
			
			<?php 
			$count = 0;
			$args = array( 'post_type' => 'portfolio', 'posts_per_page' => ( $projects_per_row * $number_of_rows ) );  
    	    $loop = new WP_Query( $args );
   	   		
			//output the latest projects from the 'my_portfolio' custom post type
	        while ($loop->have_posts()) : $loop->the_post();
				$count++;
				$preview_img_url = eq_get_the_preview_img_url();
			?>
			
				<!-- START .latest-project -->
				<div class="latest-project <?php echo $grid_class; if ( $count === 1 ) { echo " alpha"; } elseif ( $count === $projects_per_row ) { echo " omega"; $count = 0; } ?>">
					
					<?php if ($preview_img_url) { ?>
						
				    	<?php $large_image_url = wp_get_attachment_image_src( eq_get_attachment_id_from_src( $preview_img_url ), 'full'); ?>
				    	
				    	<a class="project-link" href="<?php the_permalink(); ?>" >
				    		<img width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>" src="<?php echo get_template_directory_uri() . '/timthumb.php?src=' . $large_image_url[0]; ?>&amp;h=<?php echo $image_height; ?>&amp;w=<?php echo $image_width; ?>&amp;q=<?php echo $quality; ?>" alt="<?php _e( 'Portfolio Item', 'onioneye' ); ?>" /> 
				    		<span>view project</span>
				    	</a>
			    	
			    	<?php } ?>
			    	
					<h3><center><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></center></h3>
				</div>
				<!-- END .latest-project -->
			
			<?php endwhile; ?>
			
		</section>
		<!-- END .latest-projects -->
		
		
		
	
<?php get_footer(); ?>